local assets=
{ 
    Asset("ANIM", "anim/hat_disorganized.zip"),
    Asset("ANIM", "anim/hat_disorganized_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/hat_disorganized.xml"),
    Asset("IMAGE", "images/inventoryimages/hat_disorganized.tex"),
}

local prefabs = 
{
}

local function fn()

    local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_disorganized_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        print('A')
        if owner:HasTag("player") then
            print('B')
            owner.AnimState:Hide("HEAD")
            owner.AnimState:Show("HEAD_HAIR")
        end
        owner:AddTag("trigger_disorganized")
        owner:PushEvent("formchange")
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAIR")
        end
		owner:RemoveTag("trigger_disorganized")
        owner:PushEvent("formchange")
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("hat_disorganized")
    anim:SetBuild("hat_disorganized")
    anim:PlayAnimation("idle")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "hat_disorganized"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_disorganized.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    return inst
end

return  Prefab("common/inventory/hat_disorganized", fn, assets, prefabs)